** Ansell Samuels Tables for Chapter Eight ***

*** Please use "Ansell Samuels Chapter Eight WVS.dta" which is drawn from the World Values Survey

*** Code includes esttab commands to produce tables, information available at http://repec.org/bocode/e/estout/esttab.html

*** Code also uses edvreg command created by Eduardo Leoni (available on our website)


*** Conditional Effects of Income on Redistributive Preferences (Table 8.3 and Figure 8.2) **

edvreg  inc_coef_by_co_nosa gini   if country_wave_survey_id==1, dvste(sd_inc_coef_by_co_nosa) cluster(country) borjas
eststo m1



edvreg  inc_coef_by_co_nosa gini  log_gdp  polity2 elf_4  if country_wave_survey_id==1, dvste(sd_inc_coef_by_co_nosa) cluster(country) borjas
eststo m2

edvreg  adv_inc_coef_by_co gini  if country_wave_survey_id==1, dvste(sd_adv_inc_coef_by_co) cluster(country) borjas
eststo m3


edvreg  adv_inc_coef_by_co gini  log_gdp  polity2 elf_4  if country_wave_survey_id==1, dvste(sd_adv_inc_coef_by_co) cluster(country) borjas
eststo m4

edvreg  wt_adv_inc_coef_by_co gini   if country_wave_survey_id==1, dvste(sd_wt_adv_inc_coef_by_co) cluster(country) borjas
eststo m5


edvreg  wt_adv_inc_coef_by_co gini  log_gdp  polity2 elf_4  if country_wave_survey_id==1, dvste(sd_wt_adv_inc_coef_by_co) cluster(country) borjas
eststo m6

twoway (rspike hi_wt_adv_inc_coef_by_co lo_wt_adv_inc_coef_by_co gini if country_wave_survey_id==1, lc(gs9) sort) ///
(scatter wt_adv_inc_coef_by_co gini if country_wave_survey_id==1, mlabel(country) mlabc(black) msymbol(oh) mc(black)) ,graphregion(fcolor(white))  ///
ytitle("Estimated Effect of Income") yline(0, lcolor(gs3) lpattern(dash)) ysc(titlegap(medium)) legend (lab(1 "95% Confidence Intervals") lab(2 "Point Estimates") size(small)) 
graph export "../figures/income_effect.png", replace

esttab m1 m2 m3 m4 m5 m6 using "income_effect.tex", b(%12.3f) se(%12.3f) replace label star (\dag 0.12 * 0.10 ** 0.05 *** 0.01) booktabs compress scalars("N_clust Countries")  sfmt(%2.0f) ///
coeflabels (gini "Gini" log_gdp "GDP p.c" polity2 "Polity" elf_4 "ELF") mtitles("Basic" "Basic" "Full" "Full" "Weighted" "Weighted")



*** Effects of Inequality on Citizens' Typical Redistributive Preferences (Table 8.4 and Figure 8.3) ***

edvreg  wt_adv_fifth_cons_by_co gini  log_gdp  polity2 elf_4  if country_wave_survey_id==1, dvste(sd_wt_adv_fifth_cons_by_co) cluster(country) borjas
eststo m1a
twoway (rspike hi_wt_adv_fifth_cons_by_co lo_wt_adv_fifth_cons_by_co gini if country_wave_survey_id==1, lc(gs9) sort) ///
(scatter wt_adv_fifth_cons_by_co gini if country_wave_survey_id==1, mlabel(country) mlabc(black) msymbol(oh) mc(black)), ///
ytitle("Estimate of Constant") ysc(titlegap(medium)) legend (lab(1 "95% Confidence Intervals") lab(2 "Point Estimates") size(small)) ///
 title("Estimates for 5th Percentile of Income", size(medium) margin(medium)) scheme(Lean2) ylabel(, nogrid) legend(off)
graph export "../figures/5thpct.png", replace


edvreg  wt_adv_twfifth_cons_by_co gini  log_gdp  polity2 elf_4  if country_wave_survey_id==1, dvste(sd_wt_adv_twfifth_cons_by_co) cluster(country) borjas
eststo m2a
twoway (rspike hi_wt_adv_twfifth_cons_by_co lo_wt_adv_twfifth_cons_by_co gini if country_wave_survey_id==1, lc(gs9) sort) ///
(scatter wt_adv_twfifth_cons_by_co gini if country_wave_survey_id==1, mlabel(country) mlabc(black) msymbol(oh) mc(black)), ///
ytitle("Estimate of Constant") ysc(titlegap(medium)) legend (lab(1 "95% Confidence Intervals") lab(2 "Point Estimates") size(small)) ///
 title("Estimates for 25th Percentile of Income", size(medium) margin(medium)) scheme(Lean2) ylabel(, nogrid) legend(off)
graph export "../figures/25thpct.png", replace


edvreg  wt_adv_cons_by_co gini  log_gdp  polity2 elf_4  if country_wave_survey_id==1, dvste(sd_wt_adv_cons_by_co) cluster(country) borjas
eststo m3a
twoway (rspike hi_wt_adv_cons_by_co lo_wt_adv_cons_by_co gini if country_wave_survey_id==1, lc(gs9) sort) ///
(scatter wt_adv_cons_by_co gini if country_wave_survey_id==1, mlabel(country) mlabc(black) msymbol(oh) mc(black)), ///
ytitle("Estimate of Constant") ysc(titlegap(medium)) legend (lab(1 "95% Confidence Intervals") lab(2 "Point Estimates") size(small)) ///
 title("Estimates for 50th Percentile of Income", size(medium) margin(medium)) scheme(Lean2) ylabel(, nogrid) legend(off)
graph export "../figures/50thpct.png", replace


edvreg  wt_adv_svfifth_cons_by_co gini  log_gdp  polity2 elf_4  if country_wave_survey_id==1, dvste(sd_wt_adv_svfifth_cons_by_co) cluster(country) borjas
eststo m4a
twoway (rspike hi_wt_adv_svfifth_cons_by_co lo_wt_adv_svfifth_cons_by_co gini if country_wave_survey_id==1, lc(gs9) sort) ///
(scatter wt_adv_svfifth_cons_by_co gini if country_wave_survey_id==1, mlabel(country) mlabc(black) msymbol(oh) mc(black)), ///
ytitle("Estimate of Constant") ysc(titlegap(medium)) legend (lab(1 "95% Confidence Intervals") lab(2 "Point Estimates") size(small)) ///
 title("Estimates for 75th Percentile of Income", size(medium) margin(medium)) scheme(Lean2) ylabel(, nogrid) legend(off)
graph export "../figures/75thpct.png", replace


edvreg  wt_adv_nififth_cons_by_co gini  log_gdp  polity2 elf_4  if country_wave_survey_id==1, dvste(sd_wt_adv_nififth_cons_by_co) cluster(country) borjas
eststo m5a

twoway (rspike hi_wt_adv_nififth_cons_by_co lo_wt_adv_nififth_cons_by_co gini if country_wave_survey_id==1, lc(gs9) sort) ///
(scatter wt_adv_nififth_cons_by_co gini if country_wave_survey_id==1, mlabel(country) mlabc(black) msymbol(oh) mc(black)), ///
ytitle("Estimate of Constant") ysc(titlegap(medium)) legend (lab(1 "95% Confidence Intervals") lab(2 "Point Estimates") size(small)) ///
 title("Estimates for 95th Percentile of Income", size(medium) margin(medium)) scheme(Lean2) ylabel(, nogrid) legend(off)
graph export "../figures/95thpct.png", replace



esttab m1a m2a m3a m4a m5a using "constantedvreg_b.tex", b(%12.3f) se(%12.3f) replace label star ( * 0.10 ** 0.05 *** 0.01) booktabs compress scalars("N_clust Countries") ///
  sfmt(%2.0f) coeflabels (gini "Gini" log_gdp "GDP p.c" polity2 "Polity" elf_4 "ELF")  mtitles("5th" "25th" "Median" "75th" "95th")


*** Preferences over State Ownership (Table 8.5)


xtreg e036 c.income  ed_level i.employ female x011 age agesq , re cluster(country)
eststo s1
xtreg e036 c.income  ed_level i.employ female x011 age agesq c.gini c.log_gdp c.elf_4 polity2, re cluster(country)
eststo s2
xtreg e036 c.income##c.gini  ed_level i.employ female x011 age agesq c.gini c.log_gdp c.elf_4 polity2, re cluster(country)
eststo s3

esttab s1 s2 s3 using "state_own.tex", b(%12.3f) se(%12.3f) replace label star (* 0.10 ** 0.05 *** 0.01) booktabs compress scalars("N_clust Countries")  sfmt(%2.0f) ///
drop (*.employ o.gini ) nodepvars nomtitles nonotes eqlabels(,none) ///
coeflabels ( 1.farmer#c.income "Income X Farmer" c.income#c.gini "Income X Gini" c.income#c.log_gdpc "Income X GDP p.c." c.income#c.dv "Income X Redis" c.income#c.elf_4 "Income X ELF" c.income#c.polity2  "Income X Polity" ///
 e036 "State Ownership" dv "Redis. Prefs" c.income#c.dv "Income X Redis" income "Income" 1.farmer "Farmer" gini "Gini" log_gdp "Log GDP p.c." polity2 "Polity" elf_4 "ELF" age "Age" agesq "Age Sq." female "Female" x011 "Children" ed_level "Education") 

 *** Views on Whether Democracy is Desirable (Binary) (Table 8.6a)
  
probit e117_dummy c.income  ed_level i.employ female x011 age agesq [pweight=s017], cluster(country)
eststo d1
probit e117_dummy  c.income  ed_level i.employ female x011 age agesq c.gini c.log_gdp c.elf_4 polity2 [pweight=s017], cluster(country)
eststo d2
probit e117_dummy  c.income  ed_level i.employ female x011 age agesq i.farmer c.gini c.log_gdp c.elf_4 polity2 [pweight=s017], cluster(country)
eststo p3
probit e117_dummy  c.income  ed_level i.employ female x011 age agesq e036 c.gini c.log_gdp c.elf_4 polity2 [pweight=s017], cluster(country)
eststo d3
probit e117_dummy  c.income  ed_level i.employ female x011 age agesq c.dv c.gini c.log_gdp c.elf_4 polity2 [pweight=s017], cluster(country)
eststo d4
probit e117_dummy  c.income##c.gini  ed_level i.employ female x011 age agesq e036 dv c.log_gdp c.elf_4 polity2 [pweight=s017], cluster(country)
eststo d5


esttab d1 d2 d3 d4  d5 using "dem_good_a.tex", b(%12.3f) se(%12.3f) replace label star (* 0.10 ** 0.05 *** 0.01) booktabs compress scalars("N_clust Countries")  sfmt(%2.0f) ///
drop (*.employ  ) nodepvars nomtitles nonotes eqlabels(,none) ///
coeflabels ( 1.farmer#c.income "Income X Farmer" c.income#c.gini "Income X Gini" c.income#c.log_gdpc "Income X GDP p.c." c.income#c.dv "Income X Redis" c.income#c.elf_4 "Income X ELF" c.income#c.polity2  "Income X Polity" ///
 e036 "State Ownership" dv "Redis. Prefs" c.income#c.dv "Income X Redis" income "Income" 1.farmer "Farmer" gini "Gini" log_gdp "Log GDP p.c." polity2 "Polity" elf_4 "ELF" age "Age" agesq "Age Sq." female "Female" x011 "Children" ed_level "Education") 
 
 *** Views on Whether Democracy is Desirable (Ordinal) (Table 8.6b) 

 oprobit e117_rev c.income  ed_level i.employ female x011 age agesq c.gini c.log_gdp c.elf_4 polity2 [pweight=s017], cluster(country)
eststo d6
oprobit e117_rev c.income c.dv e036  ed_level i.employ female x011 age agesq c.gini c.log_gdp c.elf_4 polity2 [pweight=s017], cluster(country)
eststo d7
oprobit e117_rev c.income##c.dv  ed_level  e036 i.employ female x011 age agesq c.gini c.log_gdp c.elf_4 polity2 [pweight=s017], cluster(country)
eststo d8
oprobit e117_rev c.income##c.dv e036 c.income#c.e036  ed_level i.employ female x011 age agesq c.gini c.log_gdp c.elf_4 polity2 [pweight=s017], cluster(country)
eststo d9
oprobit e117_rev c.income##c.gini dv e036  ed_level i.employ female x011 age agesq c.gini c.log_gdp c.elf_4 polity2 [pweight=s017], cluster(country)
eststo d10

esttab d6 d7 d8 d9 d10  using "dem_good_b.tex", b(%12.3f) se(%12.3f) replace label star (* 0.10 ** 0.05 *** 0.01) booktabs compress scalars("N_clust Countries")  sfmt(%2.0f) ///
drop (*.employ  cut*: o.gini) nodepvars nomtitles nonotes eqlabels(,none) ///
coeflabels ( 1.farmer#c.income "Income X Farmer" c.income#c.gini "Income X Gini" c.income#c.log_gdpc "Income X GDP p.c." c.income#c.dv "Income X Redis" c.income#c.elf_4 "Income X ELF" c.income#c.polity2  "Income X Polity" ///
 dv "Redis. Prefs" e036 "State Ownership" c.income#c.e036 "Income X Own." c.income#c.dv "Income X Redis" income "Income" 1.farmer "Farmer" gini "Gini" log_gdp "Log GDP p.c." polity2 "Polity" elf_4 "ELF" age "Age" agesq "Age Sq." female "Female" x011 "Children" ed_level "Education") 
 
 
 *** Views on Whether Democracy is Good for the Economy (Table 8.7)
 
 
 probit e120_d c.income   ed_level i.employ female x011 age agesq [pweight=s017] , cluster(country)
eststo e1
probit e120_d c.income   ed_level i.employ female x011 age agesq  c.gini c.log_gdp c.elf_4 polity2 [pweight=s017], cluster(country)
eststo e2
probit e120_d c.income i.farmer  ed_level i.employ female x011 age agesq  c.gini c.log_gdp c.elf_4 polity2 [pweight=s017], cluster(country)
eststo e3
probit e120_d c.income e036  ed_level i.employ female x011 age agesq  c.gini c.log_gdp c.elf_4 polity2 [pweight=s017], cluster(country)
eststo e3
probit e120_d c.income   ed_level i.employ female x011 age agesq dv  c.gini c.log_gdp c.elf_4 polity2 [pweight=s017], cluster(country)
eststo e4
probit e120_d c.income##c.gini   ed_level i.employ female x011 age agesq  c.log_gdp c.elf_4 polity2 [pweight=s017], cluster(country)
eststo e5

esttab e1 e2 e3 e4 e5  using "dem_econ_good.tex", b(%12.3f) se(%12.3f) replace label star (* 0.10 ** 0.05 *** 0.01) booktabs compress scalars("N_clust Countries")  sfmt(%2.0f) ///
drop (*.employ ) nodepvars nomtitles nonotes eqlabels(,none) ///
coeflabels ( 1.farmer#c.income "Income X Farmer" c.income#c.gini "Income X Gini" c.income#c.log_gdpc "Income X GDP p.c." c.income#c.dv "Income X Redis" c.income#c.elf_4 "Income X ELF" c.income#c.polity2  "Income X Polity" ///
 dv "Redis. Prefs"  e036 "State Ownership" income "Income" 1.farmer "Farmer" gini "Gini" log_gdp "Log GDP p.c." polity2 "Polity" elf_4 "ELF" age "Age" agesq "Age Sq." female "Female" x011 "Children" ed_level "Education") 

 
